	.INCLUDE	"global.inc"
	.IMPORT	BREAKPOINT
	.EXPORT	SFXPLAY, SFXUPDT
	
	.CODE
	
;**************************************
;*
;* SOUND EFFECTS
;*
;**************************************
;
; START PLAYING A SOUND EFFECT
;
SFXPLAY:	LDA	SFXDURATION,Y
	STA	SFXPOS
	TYA
	ASL
	TAY
	LDA	SFXTONE,Y
	STA	SFXPTR
	LDA	SFXTONE+1,Y
	STA	SFXPTR+1
	RTS
;
; PLAY NEXT TONE IN (REVERSE) SEQUENCE.
;
SFXUPDT:	LDY	SFXPOS
	BEQ	SFXDONE
	LDA	(SFXPTR),Y
	STA	TONE
	DEY
	STY	SFXPOS
	RTS
SFXDONE:	STY	TONE
	RTS

	.DATA
	
SFXTONE:	.ADDR	SILENCE, DOOROPEN, DOORCLOSE, POWERUP, STRUGGLE
SFXDURATION:	.BYTE	0, 11, 11, 11, 11
SILENCE:	.BYTE	$00
DOOROPEN:	.BYTE	$15, $16, $17, $18, $19, $1A, $1B, $1C, $1D, $1E, $1F, $20
DOORCLOSE:	.BYTE	$20, $1F, $1E, $1D, $1C, $1B, $1A, $19, $18, $17, $16, $15
POWERUP:	.BYTE	$02, $02, $02, $02, $02, $02, $02, $02, $04, $04, $04, $04
STRUGGLE:	.BYTE	$01, $08, $01, $08, $01, $08, $01, $08, $01, $08, $01, $08